
#############################################
### PREDICTION POWER AND BETTING STATEGY
############################################

library(skellam)
 
load("ShinProbabilitiesGer.RData")
p_shin_BundesLiga=p_shin
load("ShinProbabilitiesPL.RData")
p_shin_PL =p_shin
load("ShinProbabilitiesSpa.RData")
p_shin_Liga=p_shin
load("ShinProbabilitiesIta.RData")
p_shin_serieA=p_shin

agenzie_ita=7
p_norm_serieA=p_norm_prob(array_odds_serieA, agenzie, ngames_tot_serieA)
p_norm_PL=p_norm_prob(array_odds_PL, agenzie, ngames_tot_PL)
p_norm_Liga=p_norm_prob(array_odds_Liga, agenzie, ngames_tot_Liga)
p_norm_BundesLiga=p_norm_prob(array_odds_BundesLiga, agenzie, 
  ngames_tot_BundesLiga)

  # save(hat_theta1_prev_serieA, hat_theta2_prev_serieA,
  #   hat_theta1_prev_PL, hat_theta2_prev_PL,
  #   hat_theta1_prev_Liga, hat_theta2_prev_Liga, hat_theta1_prev_BundesLiga,
  #   hat_theta2_prev_BundesLiga,
  #   p_norm_serieA,
  #   p_norm_PL, p_norm_Liga,p_norm_BundesLiga,
  #   file="day10_save.RData")
 



agenzie_ita_nomi=c("bet365",  "bwin", "interwetten", "ladbrokes", 
                   "sportingbet", "vc bet", "williamhill" )



#################################################
#funzione provvisoria

odds_test=function(array_odds, ngames_train, ngames_tot){
array_odds_test=array_odds[(ngames_train+1):ngames_tot,,]
return(array_odds_test)
}

#############################################

#"William Hill", "NetBet", "betfair",
#"unibet", "betclick"





betting=function( string, dataset, teams,ngames_tot, ngames_test, ngames_train,
                  hat_theta1_prev, hat_theta2_prev, array_odds,
                  team1_prev, team2_prev, p_norm, p_shin,
                  gol_vero1, gol_vero2,thresholdA, thresholdA2, 
                  puntata_fissa_A,
                  puntata_fissa_A2, agenzie){
  
  average_p_correct_basic=average_p_correct_shin=c()
  
  results=c()
  results[dataset[,5]=="H"]=1; 
  results[dataset[,5]=="D"]=2; 
  results[dataset[,5]=="A"]=3
  results_test=results[(ngames_train+1):ngames_tot]
  
  odds_inv_test=1/array_odds
  
  
  p_norm_test=p_norm[(ngames_train+1):(ngames_tot),,]
  p_shin_test =p_shin[(ngames_train+1):(ngames_tot),,]
  p_kroenecker_basic=matrix(NA, ngames_test, agenzie)
  p_kroenecker_shin=matrix(NA, ngames_test, agenzie)
  
  
  for (g in 1:agenzie){
    
    for (h in 1:ngames_test){
      
      p_kroenecker_basic[h,g]=p_norm_test[h,g,results_test[h]]
      p_kroenecker_shin[h,g]=p_shin_test[h,g,results_test[h]]
      
      
    }
    
    average_p_correct_basic[g]=mean(p_kroenecker_basic[,g])
    average_p_correct_shin[g]=mean(p_kroenecker_shin[,g])
    
    }
  
  
  
  
  hat_theta1_prev; hat_theta2_prev  # stime modello, parametri misturati
  skellam_prob=matrix(NA, ngames_test,3)
  
  for (n in 1:ngames_test)
    skellam_prob[n,]=c(pskellam(0,hat_theta1_prev[n], hat_theta2_prev[n], lower.tail=F),
                       dskellam(0, hat_theta1_prev[n], hat_theta2_prev[n] ),
                       1-pskellam(0,hat_theta1_prev[n], hat_theta2_prev[n], lower.tail=F)-
                         dskellam(0, hat_theta1_prev[n], hat_theta2_prev[n] ) )
  
  
  # p fraction of correctly predicted matches
  
  p_kroenecker=c()
  for (h in 1:ngames_test){
    p_kroenecker[h]=(  skellam_prob[h,results_test[h]  ])
  }
  average_p_correct_model=mean(p_kroenecker)
  
  p_medium=c(average_p_correct_model,mean(average_p_correct_shin),
    mean(average_p_correct_basic))
  
  #brier score
  
  results_brier <- matrix(0, ngames_test, 3)
  for(n in 1:ngames_test){
  results_brier[n, results_test[n]] <- 1 
  }
  
  brier_score_model <- (1/ngames_test)*sum( (skellam_prob-results_brier)^2)
  brier_score_basic <- (1/ngames_test)*
                        sum( ( apply(p_norm_test, c(1,3), mean)-results_brier)^2)
  brier_score_shin <- (1/ngames_test)*
                        sum( (apply(p_shin_test, c(1,3),mean)-results_brier)^2)
  
  brier_score <-c(brier_score_model, brier_score_basic, brier_score_shin)
  
  
  
  ##Guadagni attesi e varianze
  
  prob_model_odds=array(NA, c(ngames_test, agenzie,3))
  prob_book_odds_basic=array(NA, c(ngames_test, agenzie,3))
  prob_book_odds_shin=array(NA, c(ngames_test, agenzie,3))
  sort_model_odds <- array(NA, c(ngames_test, agenzie,3))
  
  
  
  max_prob_model_odds=matrix(NA, ngames_test,agenzie)
  max_prob_book_odds_basic=matrix(NA, ngames_test,agenzie)
  max_prob_book_odds_shin=matrix(NA, ngames_test,agenzie)
  
  for (g in 1:agenzie){
    prob_model_odds[,g,]=skellam_prob*array_odds[ ,g,]
    prob_book_odds_basic[,g,]=p_norm_test[,g,]*array_odds[,g,]
    prob_book_odds_shin[,g,]=p_shin[(ngames_train+1):ngames_tot,g,]*array_odds[,g,]
  }
  
  max_prob_model_odds=apply(prob_model_odds, c(1,2), max)
  max_prob_book_odds_basic=apply(prob_book_odds_basic, c(1,2), max)
  max_prob_book_odds_shin=apply(prob_book_odds_shin, c(1,2), max)
  
  #indice del profitto massimo per ogni partita e scommettitore
  
  indice_esiti=apply(prob_model_odds, c(1,2), function(x) which.max(x))
  exp.pr <- matrix(NA, ngames_test,agenzie)
  for (g in 1:agenzie){
  sort_model_odds[,g,] <- t(apply(prob_model_odds[,g,], 1, function(x) sort(x, decreasing=TRUE)))
  for (n in 1:ngames_test)
  exp.pr[n,g] <- sort_model_odds[n,g, 1]-sum(skellam_prob[n, (1:3)[(1:3)!=indice_esiti[n,g]]])
  }
  
  
  
  expected_model_return=apply(max_prob_model_odds,2,sum)
  expected_book_return_basic=apply(max_prob_book_odds_basic,2,sum)
  expected_book_return_shin=apply(max_prob_book_odds_shin,2,sum)
  
  percentage_return=(expected_model_return-ngames_test*1)/expected_model_return
  percentage_return_moneyinitial_A=(expected_model_return-ngames_test*1)/(ngames_test*1)
  percentage_return_shin_A=(expected_book_return_shin-ngames_test*1)/(ngames_test*1)
  percentage_return_basic_A=(expected_book_return_basic-ngames_test*1)/(ngames_test*1)
  
  ##Betting strategy B: 1X2 (Puntata massimizzata; Rue e Salvesen 2000)
  
  variance_profit=1.2
  
  exp_prof_var_prof=array(NA, c(ngames_test,3, agenzie))
  exp_prof_var_prof_shin=array(NA, c(ngames_test,3, agenzie))
  exp_prof_var_prof_basic=array(NA, c(ngames_test,3, agenzie))
  
  exp_prof_var_prof=prob_model_odds/(2*variance_profit)
  exp_prof_var_prof_shin=prob_book_odds_shin/(2*variance_profit)
  exp_prof_var_prof_basic=prob_book_odds_basic/(2*variance_profit)
  ideal_bet=array(NA, c(ngames_test,3, agenzie))
  ideal_bet=0+(exp_prof_var_prof)*(exp_prof_var_prof>0)
  ideal_bet_shin=array(NA, c(ngames_test,3, agenzie))
  ideal_bet_shin=0+(exp_prof_var_prof_shin)*(exp_prof_var_prof_shin>0)
  ideal_bet_basic=array(NA, c(ngames_test,3, agenzie))
  ideal_bet_basic=0+(exp_prof_var_prof_basic)*(exp_prof_var_prof_basic>0)
  
  ideal_matrix=ideal_bet*prob_model_odds
  ideal_matrix_shin=ideal_bet_shin*prob_book_odds_shin
  ideal_matrix_basic=ideal_bet_basic*prob_book_odds_basic
  
  indice_esiti_B=apply(ideal_matrix, c(1,2), function(x) which.max(x))
  
  profit_matrix=apply(ideal_matrix, c(1,2), max)
  profit_matrix_shin=apply(ideal_matrix_shin, c(1,2), max)
  profit_matrix_basic=apply(ideal_matrix_basic, c(1,2), max)
  
  index_max=apply( ideal_matrix, c(1,2), which.max )
  index_max_shin=apply( ideal_matrix_shin, c(1,2), which.max )
  index_max_basic=apply( ideal_matrix_basic, c(1,2), which.max )
  
  
  profit=apply(profit_matrix,2,sum)
  profit_shin=apply(profit_matrix_shin,2,sum)
  profit_basic=apply(profit_matrix_basic,2,sum)
  
  spesa=matrix(NA, ngames_test, agenzie)
  spesa_shin=matrix(NA, ngames_test, agenzie)
  spesa_basic=matrix(NA, ngames_test, agenzie)
  
  for (n in 1:ngames_test){
    for (h in 1:agenzie){
      spesa[n,]=ideal_bet[n,,index_max[n,h]] 
      spesa_shin[n,]=ideal_bet_shin[n,,index_max_shin[n,h]] 
      spesa_basic[n,]=ideal_bet_basic[n,,index_max_basic[n,h]] 
    }
  }
  
  spesa_tot=apply(spesa, 2, sum)
  spesa_tot_shin=apply(spesa_shin, 2, sum)
  spesa_tot_basic=apply(spesa_basic, 2, sum)
  
  percentage_return_moneyinitial_B=(profit-spesa_tot)/spesa_tot
  percentage_return_moneyinitial_B_shin=(profit_shin-spesa_tot_shin)/spesa_tot_shin
  percentage_return_moneyinitial_B_basic=(profit_basic-spesa_tot_basic)/spesa_tot_basic
  spesa_rue = spesa
  spesa_rue_tot=spesa_tot
  
  
  ## coefplot guadagni (Figure 7 paper)
  
  guadagni_singoli=(max_prob_model_odds-1)
  guadagni_singoli_shin=(max_prob_book_odds_shin-1)
  guadagni_singoli_basic=(max_prob_book_odds_basic-1)
  
  mean_profit_A=apply(guadagni_singoli,2,mean)
  mean_profit_shin=apply(guadagni_singoli_shin,2,mean)
  mean_profit_basic=apply(guadagni_singoli_basic,2,mean)
  
  sd_singole=apply(guadagni_singoli,2,sd)
  sd_singole_shin=apply(guadagni_singoli_shin,2,sd)
  sd_singole_basic=apply(guadagni_singoli_basic,2,sd)
  
  variance_model_return=apply(max_prob_model_odds,2,var)
  
  
  guadagni_singoli_B=(profit_matrix-spesa)/spesa
  guadagni_singoli_shin_B=(profit_matrix_shin-spesa_shin)/spesa_shin
  guadagni_singoli_basic_B=(profit_matrix_basic-spesa_basic)/spesa_basic
  
  mean_profit_B=apply(guadagni_singoli_B,2,mean)
  mean_profit_shin_B=apply(guadagni_singoli_shin_B,2,mean)
  mean_profit_basic_B=apply(guadagni_singoli_basic_B,2,mean)
  
  sd_singole_B=apply(guadagni_singoli_B,2,sd)
  sd_singole_shin_B=apply(guadagni_singoli_shin_B,2,sd)
  sd_singole_basic_B=apply(guadagni_singoli_basic_B,2,sd)
  
  
  book=c("Bet365", "Bwin", "Interw.", "L.brokes", "S.bet", "VC Bet", "W.Hill")
  library ("arm")
  
  pdf(file=paste("Profits", string, ".pdf", sep=""), height=6, width=6)
  
  
  coefplot(rev(mean_profit_A), rev(sd_singole), varnames=rev(book), 
    main="Expected profit (estim. +/- 1 sd)", cex.pts=1,pch=15, CI=1, 
    cex.var=.8, xlim=c(-0.5,1.4), cex.main=1, col="blue", offset=0.1)
  coefplot(rev(mean_profit_B), rev(sd_singole_B), varnames=rev(book), 
    main="Expected profit (estim. +/- 1 s.e.)", cex.pts=1.1, pch =15,
    CI=1, cex.var=.8, mar=c(0,2,5.1,1), xlim=c(-0.2,1), cex.main=1, 
    col="red",offset=0.2, add=TRUE)
   coefplot(rev(mean_profit_basic_B), rev(sd_singole_basic_B), 
     varnames=rev(book), main="Expected profit (estim. +/- 1 s.e.)", 
     cex.pts=1,pch=17,lty =2, CI=1, cex.var=.8, xlim=c(-0.2,0.8), 
     cex.main=1, col="red", offset=-0.3, add=TRUE)
 
  coefplot(rev(mean_profit_shin_B), rev(sd_singole_shin_B), varnames=rev(book), main="Expected profit (estim. +/- 1 s.e.)", cex.pts=1,pch=19,lty =3, 
    CI=1, cex.var=.8, xlim=c(-0.2,0.8), cex.main=1, col="red", offset=-0.1,
    add=TRUE)
  legend(0.9,6,c("Str. A", "Str.B","Basic Str. B",  "Shin Str.B"), 
    pch=c(15, 15, 17, 19), 
    col=c("blue", "red", "red", "red"))
  dev.off()
  
  
  #indice del profitto massimo per ogni partita e scommettitore
  
  indice_esitiA=apply(prob_model_odds, c(1,2), function(x) which.max(x))
  indice_esitiA2_vec=apply(skellam_prob, 1, function(x) which.max(x))
  indice_esitiA2=matrix(rep(indice_esitiA2_vec, agenzie), ngames_test, agenzie)
  
  
  terna=c("1", "X", "2")
  
  esitiA=matrix(0, ngames_test, agenzie)
  esitiA2=matrix(0, ngames_test, agenzie)
  strategia_esitiA=matrix(0, ngames_test, agenzie)
  strategia_esitiA2=matrix(0, ngames_test, agenzie)
  strategia_esitiB=matrix(0, ngames_test, agenzie)
  strategia_esitiB2=matrix(0, ngames_test, agenzie)
  for (t in 1:(ngames_test)){
    for (g in 1:agenzie){
      esitiA[t,g]=terna[indice_esitiA[t,g]]
      esitiA2[t,g]=terna[indice_esitiA2[t,1]]
      if (  skellam_prob[t, indice_esitiA[t,g]]>thresholdA*odds_inv_test[t,g,indice_esitiA[t,g]] )
      {
        
        strategia_esitiA[t,g]=-puntata_fissa_A
        strategia_esitiB[t,g]=-ideal_bet[t,g,indice_esitiA[t,g] ]*puntata_fissa_A
      }
      if (  skellam_prob[t, indice_esitiA2[t,1]]>thresholdA2*odds_inv_test[t,g,indice_esitiA2[t,1]] )
      {
        strategia_esitiA2[t,g]=-puntata_fissa_A2
        strategia_esitiB2[t,g]=-ideal_bet[t,g,indice_esitiA2[t,1] ]*puntata_fissa_A2
      }
      }}
  
  
  
  tab_prob=cbind(teams[team1_prev], teams[team2_prev], round(skellam_prob,3))
  dimnames(tab_prob)[2]=list(v=
                               c("Home team", "Away team", "P_home", "P_draw", "P_away"))
  
  
  strategia_esitoA=matrix(NA,ngames_test, agenzie)
  for (t in 1:ngames_test){
    for (g in 1:agenzie){
      if(strategia_esitiA[t,g]==0){
        strategia_esitoA[t,g]="non punto"
      }else{
      strategia_esitoA[t,g]=paste(strategia_esitiA[t,g], "su", esitiA[t,g])
      }
    }
  }
  
  contatore_puntate_A=sum(strategia_esitoA!="non punto")
  
  
  strategia_esitoA2=matrix(NA,ngames_test, agenzie)
  for (t in 1:ngames_test){
    for (g in 1:agenzie){
      if(strategia_esitiA2[t,g]==0){
        strategia_esitoA2[t,g]="non punto"
      }else{
      strategia_esitoA2[t,g]=paste(strategia_esitiA2[t,g], "su", esitiA2[t,g])
      }
    }
  }
  
  strategia_esitoB=matrix(NA,ngames_test, agenzie)
  for (t in 1:ngames_test){
    for (g in 1:agenzie){
      strategia_esitoB[t,g]=paste(round(strategia_esitiB[t,g],3), "su", esitiA[t,g])
    }
  }
  
  
  strategia_esitoB2=matrix(NA,ngames_test, agenzie)
  for (t in 1:ngames_test){
    for (g in 1:agenzie){
      strategia_esitoB2[t,g]=paste(round(strategia_esitiB2[t,g],3), "su", esitiA2[t,g])
    }
  }
  
  
  lista_scommettitori_A=lista_scommettitori_A2=
  lista_scommettitori_B=lista_scommettitori_B2=list()
  colonne_scommettitori_sel_A2=colonne_scommettitori_sel_A=c()
  for (t in 1:ngames_test){
    lista_scommettitori_A[[t]]=(1:agenzie)[strategia_esitiA[t,]!=0]
    lista_scommettitori_A2[[t]]=(1:agenzie)[strategia_esitiA2[t,]!=0]
    lista_scommettitori_B[[t]]=(1:agenzie)[strategia_esitiB[t,]!=0]
    lista_scommettitori_B2[[t]]=(1:agenzie)[strategia_esitiB2[t,]!=0]
    
    if (length(lista_scommettitori_A2[[t]])==0){
      
      colonne_scommettitori_sel_A2[t]=0
      
    }else{
      
      colonne_scommettitori_sel_A2[t]=which.max(array_odds[t,lista_scommettitori_A2[[t]],indice_esitiA2[t,1]])
      }
  }
  
  
  
  strategia_esitoA2_finale=strategia_esitoA_finale=
    strategia_esitoB_finale=strategia_esitoB2_finale=c()
  for (t in 1:ngames_test){
   if (colonne_scommettitori_sel_A2[t]==0 | sum(strategia_esitiA2[t,]==0)==agenzie){
      strategia_esitoA2_finale[t]="non punto"
    }else{
    
    strategia_esitoA2_finale[t]=paste(strategia_esitiA2[t], "su", esitiA2[t,1],":", agenzie_ita_nomi[colonne_scommettitori_sel_A2[t] ])
    }
    
    contatore_puntate_A2_aggr=sum(strategia_esitoA2_finale!="non punto")
    }
  
  
  
  
  
  tab_strategiaA=cbind(teams[team1_prev], teams[team2_prev], strategia_esitoA)
  dimnames(tab_strategiaA)[2]=list(v=c("Home team", "Away team", 
                                       agenzie_ita_nomi))
  
  tab_strategiaA2=cbind(teams[team1_prev], teams[team2_prev],strategia_esitoA2)
  dimnames(tab_strategiaA2)[2]=list(v=c("Home team", "Away team", 
                                        agenzie_ita_nomi))
  
  
  tab_strategiaA2_finale=cbind(teams[team1_prev], teams[team2_prev],strategia_esitoA2_finale)
  dimnames(tab_strategiaA2_finale)[2]=list(v=c("Home team", "Away team", 
                                        "Che faccio?"))
  
  
  tab_strategiaB=cbind(teams[team1_prev], teams[team2_prev], (strategia_esitoB))
  dimnames(tab_strategiaB)[2]=list(v=c("Home team", "Away team", 
                                       agenzie_ita_nomi))
  
  #tab_strategiaB_finale=cbind(teams[team1_prev], teams[team2_prev],strategia_esitoB_finale)
  #dimnames(tab_strategiaB_finale)[2]=list(v=c("Home team", "Away team", 
   #                                           agenzie_ita_nomi))
  
  
  tab_strategiaB2=cbind(teams[team1_prev], teams[team2_prev], (strategia_esitoB2))
  dimnames(tab_strategiaB2)[2]=list(v=c("Home team", "Away team", 
                                        agenzie_ita_nomi))
  
  #tab_strategiaB2_finale=cbind(teams[team1_prev], teams[team2_prev],strategia_esitoB2_finale)
  #dimnames(tab_strategiaB2_finale)[2]=list(v=c("Home team", "Away team", 
   #                                            agenzie_ita_nomi))
  
  #soldi effettivi strategia A
  
  
  if (sum(is.na(gol_vero1))<ngames_test & sum(is.na(gol_vero2))<ngames_test  ){
    
    gol_vero1=gol_vero1[is.na(gol_vero1)==FALSE]
    gol_vero2=gol_vero2[is.na(gol_vero2)==FALSE]
    
    ngames_test_na=length(gol_vero1)
    
    
    
    guadagno_precedente_A=function(indice, threshold){
      
      
      
      money<-matrix(0, ngames_test_na, agenzie)
      spesa<-matrix(0, ngames_test_na, agenzie)
      
      money[1,]<-0
      spesa[1,]=0
      
      for (t in 1:(ngames_test_na)){
        for (g in 1:agenzie){
          if (gol_vero1[t]>gol_vero2[t]){
            if (indice[t,g]==1 ){                  #sto candidando l'esito 1
              #indice_esiti[t,g]==1
              if (  skellam_prob[t,1]>threshold*odds_inv_test[t,g,1]){            #punto veramente sull'esito 1?
                money[t,g]<-puntata_fissa_A*(array_odds[t,g,1])   #vinco sull'esito 1
                spesa[t,g]=-puntata_fissa_A
              }else{
                money[t,g]=0              #non punto sull'esito 1, rimango coi soldi di prima
                spesa[t,g]=0
              }
            }else if (indice[t,g]==2){
              #indice_esiti[t,g]==2
              if ( skellam_prob[t,2]>threshold*odds_inv_test[t,g,2] ){   #punto su altri esiti?
                
                
                money[t,g]=0                    #punto e perdo su altri esiti
                spesa[t,g]=-puntata_fissa_A
              }else{
                money[t,g]=0                                 #rimango coi soldi di prima
                spesa[t,g]=0
              }
            }else if(indice[t,g]==3){
              #indice_esiti[t,g]==3
              if ( skellam_prob[t,3]>threshold*odds_inv_test[t,g,3] ){   #punto su altri esiti?
                
                
                money[t,g]=0                    #punto e perdo su altri esiti
                spesa[t,g]=-puntata_fissa_A
              }else{
                money[t,g]=0                                 #rimango coi soldi di prima
                spesa[t,g]=0
              }
              
            }
            
          }else if (gol_vero1[t]==gol_vero2[t]){
            if ( indice[t,g]==2){
              #indice_esiti[t,g]==2
              if (skellam_prob[t,2]>threshold*odds_inv_test[t,g,2] ){
                money[t,g]<-puntata_fissa_A*(array_odds[t,g,2])
                spesa[t,g]=-puntata_fissa_A
              }else{
                money[t,g]=0
                spesa[t,g]=0
              }
            }else if (indice[t,g]==1){
              #indice_esiti[t,g]==1
              if ( skellam_prob[t,1]>threshold*odds_inv_test[t,g,1] ){
                
                
                money[t,g]=0
                spesa[t,g]=-puntata_fissa_A
              }else{
                
                money[t,g]=0
                spesa[t,g]=0
              }
            }else if(indice[t,g]==3){
              #indice_esiti[t,g]==3
              if (skellam_prob[t,3]>threshold*odds_inv_test[t,g,3] ){
                
                
                money[t,g]=0
                spesa[t,g]=-puntata_fissa_A
              }else{
                
                money[t,g]=0
                spesa[t,g]=0
              }
              
              
              
            }
          }else if (gol_vero1[t]<gol_vero2[t]){
            if (indice[t,g]==3  ){
              #indice_esiti[t,g]==3
              if (skellam_prob[t,3]>threshold*odds_inv_test[t,g,3]){
                money[t,g]<-puntata_fissa_A*(array_odds[t,g,3])
                spesa[t,g]=-puntata_fissa_A
              }else{
                money[t,g]=0
                spesa[t,g]=0
              }
            }else if (indice[t,g]==1){
              #indice_esiti[t,g]==1
              
              if ( skellam_prob[t,1]>threshold*odds_inv_test[t,g,1]){
                
                
                money[t,g]=0
                spesa[t,g]=-puntata_fissa_A
              }else{
                
                money[t,g]=0
                spesa[t,g]=0
              }
            }else if(indice[t,g]==2){
              #indice_esiti[t,g]==2
              
              if ( skellam_prob[t,2]>threshold*odds_inv_test[t,g,2]){
                
                
                money[t,g]=0
                spesa[t,g]=-puntata_fissa_A
              }else{
                
                money[t,g]=0
                spesa[t,g]=0
                
                
                
              }
            }}
        }}
      
      return(     list(guadagno=apply(money,2,sum)+apply(spesa,2,sum),
                       ricavo=apply(money,2,sum),spesa= apply(spesa,2,sum)))
    }
  
  ## Soldi effettivi strategia A2 aggregata
  
    guadagno_precedente_A_aggr=function(indice, threshold){
      
      
      
      money<-c()
      spesa<-c()
      
      money[1]<-0
      spesa[1]=0
      
      for (t in 1:(ngames_test_na)){
        
        if (   colonne_scommettitori_sel_A2[t]==0 | sum(strategia_esitiA2[t,]==0)==agenzie ){
          
          money[t]<-0   #vinco sull'esito 1
          spesa[t]=0
        }else{
          
          
          if (gol_vero1[t]>gol_vero2[t]){
            
            if (indice[t,1]==1 ){                  #sto candidando l'esito 1
              
              
              
              money[t]=puntata_fissa_A2*(array_odds[t,colonne_scommettitori_sel_A2[t],1])             
              spesa[t]=-puntata_fissa_A2
              
            }else if (indice[t,1]==2){
              
             
                
                
                money[t]=0                    #punto e perdo su altri esiti
                spesa[t]=-puntata_fissa_A2
              
            }else if(indice[t,1]==3){
              #indice_esiti[t,g]==3
              
                
                
                money[t]=0                    #punto e perdo su altri esiti
                spesa[t]=-puntata_fissa_A2
            }
            
          }else if (gol_vero1[t]==gol_vero2[t]){
            if ( indice[t,g]==2){
              #indice_esiti[t,g]==2
              
                money[t]<-puntata_fissa_A2*(array_odds[t,colonne_scommettitori_sel_A2[t],2])
                spesa[t]=-puntata_fissa_A2
              
            }else if (indice[t,1]==1){
              #indice_esiti[t,g]==1
             
                
                
                money[t]=0
                spesa[t]=-puntata_fissa_A2
              
            }else if(indice[t,1]==3){
              #
                
                
                money[t]=0
                spesa[t]=-puntata_fissa_A2
             
              
            }
              
            
          }else if (gol_vero1[t]<gol_vero2[t]){
            if (indice[t,g]==3  ){
             
                money[t]<-puntata_fissa_A2*(array_odds[t,colonne_scommettitori_sel_A2[t],3])
                spesa[t]=-puntata_fissa_A2
             
            }else if (indice[t,1]==1){
              #indice_esiti[t,g]==1
              
              
                
                
                money[t]=0
                spesa[t]=-puntata_fissa_A2
              
            }else if(indice[t,1]==2){
              #indice_esiti[t,g]==2
              
              
                
                money[t]=0
                spesa[t]=-puntata_fissa_A2
              
            }}
          }
       }
      
      return(list(guadagno=sum(money)+sum(spesa),
                       ricavo=sum(money),spesa=sum(spesa)))
    }
    
    
    
    
  
  
  
  #soldi effettivi strategia B
  
  guadagno_precedente_B=function(indice){
    
    
    money<-matrix(0, ngames_test_na, agenzie)
    spesa<-matrix(0, ngames_test_na, agenzie)
    
    money[1,]<-0
    spesa[1,]=0
    
    for (t in 1:(ngames_test_na)){
      for (g in 1:agenzie){
        if (gol_vero1[t]>gol_vero2[t]){
          if (indice[t]==1 ){                  #sto candidando l'esito 1
            #indice_esiti[t,g]==1
            if (  skellam_prob[t,1]>odds_inv_test[t,g,1]){            #punto veramente sull'esito 1?
              money[t,g]<-ideal_bet[t,g,1]*(array_odds[t,g,1])   #vinco sull'esito 1
              spesa[t,g]=-ideal_bet[t,g,1]
            }else{
              money[t,g]=0              #non punto sull'esito 1, rimango coi soldi di prima
              spesa[t,g]=0
            }
          }else if (indice[t]==2){
            #indice_esiti[t,g]==2
            if ( skellam_prob[t,2]>odds_inv_test[t,g,2] ){   #punto su altri esiti?
              
              
              money[t,g]=0                    #punto e perdo su altri esiti
              spesa[t,g]=-ideal_bet[t,g,1]
            }else{
              money[t,g]=0                                 #rimango coi soldi di prima
              spesa[t,g]=0
            }
          }else if(indice[t]==3){
            #indice_esiti[t,g]==3
            if ( skellam_prob[t,3]>odds_inv_test[t,g,3] ){   #punto su altri esiti?
              
              
              money[t,g]=0                    #punto e perdo su altri esiti
              spesa[t,g]=-ideal_bet[t,g,1]
            }else{
              money[t,g]=0                                 #rimango coi soldi di prima
              spesa[t,g]=0
            }
            
          }
          
        }else if (gol_vero1[t]==gol_vero2[t]){
          if ( indice[t]==2){
            #indice_esiti[t,g]==2
            if (skellam_prob[t,2]>odds_inv_test[t,g,2] ){
              money[t,g]<-ideal_bet[t,g,2]*(array_odds[t,g,2])
              spesa[t,g]=-ideal_bet[t,g,2]
            }else{
              money[t,g]=0
              spesa[t,g]=0
            }
          }else if (indice[t]==1){
            #indice_esiti[t,g]==1
            if ( skellam_prob[t,1]>odds_inv_test[t,g,1] ){
              
              
              money[t,g]=0
              spesa[t,g]=-ideal_bet[t,g,2]
            }else{
              
              money[t,g]=0
              spesa[t,g]=0
            }
          }else if(indice[t]==3){
            #indice_esiti[t,g]==3
            if (skellam_prob[t,3]>odds_inv_test[t,g,3] ){
              
              
              money[t,g]=0
              spesa[t,g]=-ideal_bet[t,g,2]
            }else{
              
              money[t,g]=0
              spesa[t,g]=0
            }
            
            
            
          }
        }else if (gol_vero1[t]<gol_vero2[t]){
          if (indice[t]==3  ){
            #indice_esiti[t,g]==3
            if (skellam_prob[t,3]>odds_inv_test[t,g,3]){
              money[t,g]<-ideal_bet[t,g,3]*(array_odds[t,g,3])
              spesa[t,g]=-ideal_bet[t,g,3]
            }else{
              money[t,g]=0
              spesa[t,g]=0
            }
          }else if (indice[t]==1){
            #indice_esiti[t,g]==1
            
            if ( skellam_prob[t,1]>odds_inv_test[t,g,1]){
              
              
              money[t,g]=0
              spesa[t,g]=-ideal_bet[t,g,3]
            }else{
              
              money[t,g]=0
              spesa[t,g]=0
            }
          }else if(indice[t]==2){
            #indice_esiti[t,g]==2
            
            if ( skellam_prob[t,2]>odds_inv_test[t,g,2]){
              
              
              money[t,g]=0
              spesa[t,g]=-ideal_bet[t,g,3]
            }else{
              
              money[t,g]=0
              spesa[t,g]=0
              
              
              
            }
          }}
      }}
    
    return(     list(guadagno=apply(money,2,sum)+apply(spesa,2,sum),
                     ricavo=apply(money,2,sum),spesa= apply(spesa,2,sum)))
  }
  
  
  
  tab_guadagni_A=cbind( rbind(guadagno_precedente_A(indice_esitiA, thresholdA)$guadagno, 
                            guadagno_precedente_A(indice_esitiA,thresholdA)$ricavo,
                            guadagno_precedente_A(indice_esitiA,thresholdA)$spesa),
                        rbind(sum(guadagno_precedente_A(indice_esitiA,thresholdA)$guadagno),
                              sum(guadagno_precedente_A(indice_esitiA,thresholdA)$ricavo),
                              sum(guadagno_precedente_A(indice_esitiA,thresholdA)$spesa)))
  dimnames(tab_guadagni_A)=list(Soldi=c("Guadagno", "Ricavo", "Spesa"),Agenzie=c(rep(agenzie_ita_nomi,1), "Totale strategia A"))
  
  
  
  tab_guadagni_A2=cbind( rbind(guadagno_precedente_A(indice_esitiA2,thresholdA2)$guadagno, 
                              guadagno_precedente_A(indice_esitiA2, thresholdA2)$ricavo,
                              guadagno_precedente_A(indice_esitiA2,thresholdA2)$spesa),
                        rbind(sum(guadagno_precedente_A(indice_esitiA2,thresholdA2)$guadagno),
                              sum(guadagno_precedente_A(indice_esitiA2,thresholdA2)$ricavo),
                              sum(guadagno_precedente_A(indice_esitiA2,thresholdA2)$spesa)))
  dimnames(tab_guadagni_A2)=list(Soldi=c("Guadagno", "Ricavo", "Spesa"),
                                Agenzie=c(rep(agenzie_ita_nomi,1), "Totale strategia A2"))
  
  
  
  
  tab_guadagni_A2_aggr=cbind( rbind(guadagno_precedente_A_aggr(indice_esitiA2,thresholdA2)$guadagno, 
                               guadagno_precedente_A_aggr(indice_esitiA2, thresholdA2)$ricavo,
                               guadagno_precedente_A_aggr(indice_esitiA2,thresholdA2)$spesa))
  
  dimnames(tab_guadagni_A2_aggr)=list(Soldi=c("Guadagno", "Ricavo", "Spesa"),
                                 Agenzie= "Totale strategia A2 aggr")

  
  
  
  return(list(average_p_correct_model= average_p_correct_model,
              brier_score=brier_score,
              p_medium=p_medium,
              results_test=results_test,
              prob_model_odds=prob_model_odds,
              exp.pr = exp.pr,
              spesa_rue=spesa_rue,
              spesa_rue_tot=spesa_rue_tot,
              ngames_test_na=ngames_test_na,
              ta_prob=tab_prob, 
              tab_A=tab_strategiaA, tab_A2=tab_strategiaA2, 
              tab_B=tab_strategiaB, tab_B2=tab_strategiaB2,
              tab_guadagni_A=tab_guadagni_A,
              tab_guadagni_A2=tab_guadagni_A2,
              tab_guadagni_A2_aggr=tab_guadagni_A2_aggr, 
              tab_A2_fin=tab_strategiaA2_finale,
              contatore_puntate_A=contatore_puntate_A,
              contatore_puntate_A2_aggr=contatore_puntate_A2_aggr))
  
  
  }else{
    
     return(list(ta_prob=tab_prob, 
                 brier_score = brier_score,
                 p_medium=p_medium,
                 spesa_rue=spesa_rue,
                 spesa_rue_tot=spesa_rue_tot,
                 tab_A=tab_strategiaA, tab_A2=tab_strategiaA2, 
                 tab_B=tab_strategiaB, tab_B2=tab_strategiaB2,
                 tab_A2_fin=tab_strategiaA2_finale,
                 contatore_puntate_A=contatore_puntate_A,
                 contatore_puntate_A2_aggr=contatore_puntate_A2_aggr))
     }
  
  
  
  
}

serieA_betting=betting("Ita",dataset=serieA, teams=teams_serieA, 
                       ngames_tot=ngames_tot_serieA,
                       ngames_test=ngames_test_serieA, 
                       ngames_train=ngames_train_serieA,
                       hat_theta1_prev=hat_theta1_prev_serieA , 
                       hat_theta2_prev=hat_theta2_prev_serieA, 
                       array_odds=
    array_odds_serieA[(ngames_train_serieA+1):ngames_tot_serieA,,],
                       team1_prev=team1_prev_serieA, 
                       team2_prev=team2_prev_serieA,
                       p_norm=p_norm_serieA,
                       p_shin=p_shin_serieA,
                       gol_vero1=gol_vero1_serieA, gol_vero2=gol_vero2_serieA,
                       thresholdA=threshold_inputA, thresholdA2=threshold_inputA2,
                       puntata_fissa_A=puntata_fissa_A,
                       puntata_fissa_A2=puntata_fissa_A2,
                       agenzie=agenzie_ita)


PL_betting=betting("Eng", dataset=PL, teams=teams_PL, 
                   ngames_tot=ngames_tot_PL,
                   ngames_test=ngames_test_PL, 
                   ngames_train=ngames_train_PL,
                   hat_theta1_prev=hat_theta1_prev_PL , 
                   hat_theta2_prev=hat_theta2_prev_PL, 
                   array_odds=
    array_odds_PL[(ngames_train_PL+1):ngames_tot_PL,,],
                   team1_prev=team1_prev_PL, 
                   team2_prev=team2_prev_PL,
                   p_norm_PL, p_shin_PL,
                   gol_vero1=gol_vero1_PL, gol_vero2=gol_vero2_PL,
                   thresholdA=threshold_inputA, thresholdA2=threshold_inputA2,
                   puntata_fissa_A=puntata_fissa_A,
                   puntata_fissa_A2=puntata_fissa_A2, agenzie=agenzie_ita)

Liga_betting=betting("Liga", dataset=Liga, teams=teams_Liga, 
                     ngames_tot=ngames_tot_Liga,
                     ngames_test=ngames_test_Liga, 
                     ngames_train=ngames_train_Liga,
                     hat_theta1_prev=hat_theta1_prev_Liga , 
                     hat_theta2_prev=hat_theta2_prev_Liga, 
                     array_odds=
    array_odds_Liga[(ngames_train_Liga+1):ngames_tot_Liga,,],
                     team1_prev=team1_prev_Liga, 
                     team2_prev=team2_prev_Liga,
                     p_norm_Liga,
                     p_shin_Liga,
                     gol_vero1=gol_vero1_Liga, gol_vero2=gol_vero2_Liga,
                     thresholdA=threshold_inputA, thresholdA2=threshold_inputA2, 
                     puntata_fissa_A=puntata_fissa_A,
                     puntata_fissa_A2=puntata_fissa_A2, agenzie=agenzie_ita)

BundesLiga_betting=betting("Ger", 
                      dataset=BundesLiga, teams=teams_BundesLiga, 
                      ngames_tot=ngames_tot_BundesLiga,
                      ngames_test=ngames_test_BundesLiga, 
                      ngames_train=ngames_train_BundesLiga,
                      hat_theta1_prev=hat_theta1_prev_BundesLiga , 
                      hat_theta2_prev=hat_theta2_prev_BundesLiga, 
                      array_odds=
array_odds_BundesLiga[(ngames_train_BundesLiga+1):ngames_tot_BundesLiga,,], team1_prev=team1_prev_BundesLiga, 
        team2_prev=team2_prev_BundesLiga,
        p_norm_BundesLiga,
        p_shin_BundesLiga,
                           gol_vero1=gol_vero1_BundesLiga, 
                           gol_vero2=gol_vero2_BundesLiga,
                           thresholdA=threshold_inputA, 
                           thresholdA2=threshold_inputA2,
                           puntata_fissa_A=puntata_fissa_A,
                           puntata_fissa_A2=puntata_fissa_A2, 
                           agenzie=agenzie_ita)




## Tabella 3+brier_score
  
xtable(rbind(  c(round(BundesLiga_betting$p_medium,3),
  round(BundesLiga_betting$brier_score,4)),
  c(round(PL_betting$p_medium,4),round(PL_betting$brier_score,4)),
  c(round(Liga_betting$p_medium,4),round(Liga_betting$brier_score,4)),
  c(round(serieA_betting$p_medium,4), round(serieA_betting$brier_score,4))), digits =4)


























totale_fondo=120
totale_fondo_A= 35
totale_fondo_A2=85
totale_puntate=sum(serieA_betting$contatore_puntate_A, 
                   serieA_betting$contatore_puntate_A2_aggr,
PL_betting$contatore_puntate_A2_aggr,
Liga_betting$contatore_puntate_A2_aggr,
BundesLiga_betting$contatore_puntate_A2_aggr)

tot_puntate_A=serieA_betting$contatore_puntate_A
tot_puntate_A2= sum( 
  serieA_betting$contatore_puntate_A2_aggr,
  PL_betting$contatore_puntate_A2_aggr,
  Liga_betting$contatore_puntate_A2_aggr,
  BundesLiga_betting$contatore_puntate_A2_aggr)

puntata_fissa_A=round(totale_fondo_A/tot_puntate_A,0)
puntata_fissa_A2=round(totale_fondo_A2/tot_puntate_A2,0)










